﻿<%@ Page Title="TBI CDS Practitioner - Patient Demographics" Language="C#" MasterPageFile="~/MasterPageExt.master" AutoEventWireup="true"
    CodeFile="pat_demographics.aspx.cs" Inherits="pat_demographics" %>

<%@ MasterType VirtualPath="MasterPageExt.master" %>
<%@ Register TagPrefix="uc" TagName="PatPortalAccount" Src="~/ucPatPortalAccount.ascx" %>

<%@ Register Assembly="Ext.Net" Namespace="Ext.Net" TagPrefix="ext" %>

<asp:Content ID="cStyle" ContentPlaceHolderID="cpHeader" runat="server">
</asp:Content>

<asp:Content ID="cDemographics" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
            <ext:TabPanel ID="tpPatientDemographics" 
                runat="server" 
                Region="Center" 
                MarginSpec="10 0 0 0" 
                Layout="AnchorLayout" 
                AnchorHorizontal="100%" 
                AnchorVertical="100%" 
                OverflowY="Auto" 
                OverflowX="Auto" 
                Frame="false" 
                Border="false">
                <Items>
                    <ext:Panel ID="pnlDemographics" 
                        runat="server" 
                        Title="Demographics" 
                        BodyPadding="6" 
                        AnchorHorizontal="100%" 
                        AnchorVertical="100%"  
                        Frame="false" 
                        Border="false"
                        OverflowY="Auto" 
                        OverflowX="Auto">
                        <Items>
                            <ext:Panel  
                                runat="server"  
                                Frame="false" 
                                Border="false"
                                Layout="HBoxLayout">
                                <Items>
                                    <ext:Panel ID="Panel2" 
                                        runat="server" 
                                        Border="false"  
                                        Frame="false" 
                                        Margins="0 50 0 0">
                                        <Items>
                                            <ext:TextField ID="txtFirstName"
                                                Name="txtFirstName"
                                                runat="server"
                                                FieldLabel="First Name"
                                                LabelAlign="Right"
                                                Vtype="alphanum">
                                            </ext:TextField>
                                            <ext:TextField ID="txtMI"
                                                Name="txtMI"
                                                runat="server"
                                                FieldLabel="Middle Initial"
                                                LabelAlign="Right"
                                                Size="2"
                                                MaxLength="1"
                                                EnforceMaxLength="true"
                                                Vtype="alpha">
                                            </ext:TextField>
                                            <ext:TextField ID="txtLastName"
                                                Name="txtLastName"
                                                runat="server"
                                                FieldLabel="Last Name"
                                                LabelAlign="Right"
                                                Vtype="alphanum">
                                            </ext:TextField>
                                            <ext:TextField ID="txtSSN"
                                                Name="txtSSN"
                                                runat="server"
                                                FieldLabel="SSN"
                                                ValidateBlank="false"
                                                LabelAlign="Right">
                                                <Plugins>
                                                    <ext:InputMask ID="InputMask3" runat="server" Mask="999-99-9999" AllowInvalid="true" ClearWhenInvalid="false" />
                                                </Plugins>
                                            </ext:TextField>
                                            <ext:TextField ID="txtSSNConfirm"
                                                Name="txtSSNConfirm"
                                                runat="server"
                                                FieldLabel="SSN Confirm"
                                                ValidateBlank="false"
                                                LabelAlign="Right">
                                                <Plugins>
                                                    <ext:InputMask ID="InputMask4" runat="server" Mask="999-99-9999" AllowInvalid="true" ClearWhenInvalid="false" />
                                                </Plugins>
                                            </ext:TextField>
                                            <ext:TextField ID="txtAddress1"
                                                Name="txtAddress1"
                                                runat="server"
                                                FieldLabel="Address1"
                                                LabelAlign="Right"
                                                Vtype="address">
                                            </ext:TextField>
                                            <ext:TextField ID="txtAddress2"
                                                Name="txtAddress2"
                                                runat="server"
                                                FieldLabel="Address2"
                                                LabelAlign="Right"
                                                Vtype="address">
                                            </ext:TextField>
                                            <ext:TextField ID="txtCity"
                                                Name="txtCity"
                                                runat="server"
                                                FieldLabel="City"
                                                LabelAlign="Right"
                                                Vtype="address">
                                            </ext:TextField>
                                            <ext:ComboBox ID="cboState"
                                                Name="cboState" 
                                                runat="server"
                                                FieldLabel="State"
                                                Editable="false" GrowToLongestValue="true"
                                                LabelAlign="Right">
                                            </ext:ComboBox>
                                            <ext:TextField ID="txtPostalCode"
                                                Name="txtPostalCode"
                                                runat="server"
                                                FieldLabel="Postal Code"
                                                LabelAlign="Right"
                                                Vtype="postalCode">
                                            </ext:TextField>
                                            <ext:Panel ID="Panel3" 
                                                runat="server" 
                                                Layout="HBoxLayout" 
                                                Frame="false" 
                                                Border="false">
                                                <Items>
                                                    <ext:Panel ID="Panel4" 
                                                        runat="server" 
                                                        Frame="false" 
                                                        Border="false">
                                                        <Items>
                                                            <ext:TextField ID="txtWorkPhone"
                                                                Name="txtWorkPhone"
                                                                runat="server"
                                                                FieldLabel="Work Phone"
                                                                LabelAlign="Right"
                                                                Note="(Including Area Code)"
                                                                ValidateBlank="false"
                                                                NoteAlign="Down">
                                                                <Plugins>
                                                                    <ext:InputMask ID="InputMask2" runat="server" Mask="(999) 999-9999" AllowInvalid="true" ClearWhenInvalid="false" />
                                                                </Plugins>
                                                            </ext:TextField>
                                                        </Items>
                                                    </ext:Panel>
                                                    <ext:Panel ID="Panel5" 
                                                        runat="server" 
                                                        Frame="false" 
                                                        Border="false">
                                                        <Items>
                                                            <ext:Checkbox ID="chkOkCall"
                                                                Name="chkOkCall"
                                                                runat="server"
                                                                BoxLabel="Ok to call?"
                                                                HideEmptyLabel="true">
                                                            </ext:Checkbox>
                                                        </Items>
                                                    </ext:Panel>
                                                </Items>
                                            </ext:Panel>
                                            <ext:Panel ID="Panel6" 
                                                runat="server" 
                                                Layout="HBoxLayout" 
                                                Frame="false" 
                                                Border="false">
                                                <Items>
                                                    <ext:Panel ID="Panel7" 
                                                        runat="server" 
                                                        Frame="false" 
                                                        Border="false">
                                                        <Items>
                                                            <ext:TextField ID="txtCellPhone"
                                                                Name="txtCellPhone"
                                                                runat="server"
                                                                FieldLabel="Cell/Home Phone"
                                                                LabelAlign="Right"
                                                                Note="(Including Area Code)"
                                                                ValidateBlank="false"
                                                                NoteAlign="Down">
                                                                <Plugins>
                                                                    <ext:InputMask ID="InputMask1" runat="server" Mask="(999) 999-9999" AllowInvalid="true" ClearWhenInvalid="false" />
                                                                </Plugins>
                                                            </ext:TextField>
                                                        </Items>
                                                    </ext:Panel>
                                                    <ext:Panel ID="Panel8" 
                                                        runat="server" 
                                                        Frame="false" 
                                                        Border="false">
                                                        <Items>
                                                            <ext:Checkbox ID="chkOkText"
                                                                Name="chkOkCall"
                                                                runat="server"
                                                                BoxLabel="Ok to text?"
                                                                HideEmptyLabel="true">
                                                            </ext:Checkbox>
                                                        </Items>
                                                    </ext:Panel>
                                                </Items>
                                            </ext:Panel>
                                            <ext:Panel ID="Panel9" 
                                                runat="server" 
                                                Layout="HBoxLayout" 
                                                Frame="false" 
                                                Border="false">
                                                <Items>
                                                    <ext:Panel  
                                                        runat="server" 
                                                        Frame="false" 
                                                        Border="false">
                                                        <Items>
                                                            <ext:TextField ID="txtEmail"
                                                                Name="txtEmail"
                                                                runat="server"
                                                                FieldLabel="Email"
                                                                LabelAlign="Right"
                                                                AllowBlank="true"
                                                                Vtype="email">
                                                            </ext:TextField>
                                                        </Items>
                                                    </ext:Panel>
                                                    <ext:Panel  
                                                        runat="server" 
                                                        Frame="false" 
                                                        Border="false">
                                                        <Items>
                                                            <ext:Checkbox ID="chkOkEmail"
                                                                Name="chkOkEmail"
                                                                runat="server"
                                                                BoxLabel="Ok to email?"
                                                                HideEmptyLabel="true">
                                                            </ext:Checkbox>
                                                        </Items>
                                                    </ext:Panel>
                                                </Items>
                                            </ext:Panel>
                                        </Items>
                                    </ext:Panel>
                                    <ext:Panel  
                                        runat="server" 
                                        Flex="98" 
                                        Frame="false" 
                                        Border="false">
                                        <Items>
                                            <ext:DateField ID="txtDOB"
                                                Name="txtDOB"
                                                runat="server"
                                                Format="MM/dd/yyyy"
                                                FieldLabel="Date of Birth"
                                                LabelAlign="Right"
                                                Note="MM/DD/YYYY"
                                                NoteAlign="Down"
                                                Vtype="date"
                                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                            </ext:DateField>
                                            <ext:ComboBox ID="cboGender"
                                                Name="cboGender"
                                                runat="server"
                                                FieldLabel="Gender"
                                                Editable="false" GrowToLongestValue="true"
                                                LabelAlign="Right">
                                            </ext:ComboBox>
                                            <ext:ComboBox ID="cboDutyStatus"
                                                Name="cboDutyStatus"
                                                runat="server"
                                                FieldLabel="Duty Status"
                                                Editable="false" GrowToLongestValue="true"
                                                LabelAlign="Right">
                                            </ext:ComboBox>
                                            <ext:ComboBox ID="cboPreferredLanguage"
                                                Name="cboPreferredLanguage"
                                                runat="server"
                                                FieldLabel="Preferred Language"
                                                Editable="false" GrowToLongestValue="true"
                                                LabelAlign="Right">
                                                <Listeners>
                                                    <Select Fn="specifyLanguage" />
                                                </Listeners>
                                            </ext:ComboBox>
                                            <ext:TextField ID="txtPreferredLanguage"
                                                Name="txtPreferredLanguage"
                                                runat="server"
                                                FieldLabel="Specify Language"
                                                LabelAlign="Right"
                                                MaxLength="30"
                                                EnforceMaxLength="true"
                                                Hidden="true">
                                            </ext:TextField>
                                            <ext:ComboBox ID="cboEthnicity"
                                                Name="cboEthnicity"
                                                runat="server"
                                                FieldLabel="Ethnicity"
                                                Editable="false" GrowToLongestValue="true"
                                                LabelAlign="Right">
                                            </ext:ComboBox>
                                            <ext:CheckboxGroup ID="chkgrpRace"
                                                runat="server"
                                                FieldLabel="Race"
                                                ColumnsNumber="1"
                                                Vertical="true"
                                                LabelAlign="Right">
                                            </ext:CheckboxGroup>
                                            <ext:ComboBox ID="cboHandPreference"
                                                Name="cboHandPreference"
                                                runat="server"
                                                FieldLabel="Hand Preference Type"
                                                Editable="false" GrowToLongestValue="true"
                                                LabelAlign="Right">
                                            </ext:ComboBox>
                                        </Items>
                                    </ext:Panel>
                                </Items>
                            </ext:Panel>
                        </Items>
                    </ext:Panel>
                    <ext:Panel ID="pnlSocioEconomics" 
                        runat="server" 
                        Title="Socioeconomics" 
                        BodyPadding="6" 
                        AnchorHorizontal="100%" 
                        AnchorVertical="100%" 
                        OverflowY="Auto" 
                        OverflowX="Auto" 
                        Frame="false" 
                        Border="false">
                        <Items>
                            <ext:ComboBox ID="cboHighestGrade"
                                Name="cboHighestGrade"
                                runat="server"
                                FieldLabel="Highest Grade Level"
                                Editable="false"
                                LabelWidth="180"
                                Grow="true"
                                GrowToLongestValue="true"
                                GrowMin="250"
                                LabelAlign="Right">
                            </ext:ComboBox>
                            <ext:ComboBox ID="cboHighestDegree"
                                Name="cboHighestDegree"
                                runat="server"
                                FieldLabel="Highest Degree Obtained" LabelWidth="180"
                                Editable="false"
                                GrowToLongestValue="true"
                                Grow="true"
                                GrowMin="400"
                                LabelAlign="Right">
                            </ext:ComboBox>
                            <ext:ComboBox ID="cboMaritalStatus"
                                Name="cboMaritalStatus"
                                runat="server"
                                FieldLabel="Marital Status" LabelWidth="180"
                                Editable="false"
                                GrowToLongestValue="true"
                                Grow="true"
                                LabelAlign="Right">
                            </ext:ComboBox>
                            <ext:ComboBox ID="cboEmploymentStatus"
                                Name="cboEmploymentStatus"
                                runat="server"
                                FieldLabel="Employment Status" LabelWidth="180"
                                Editable="false"
                                GrowToLongestValue="true"
                                Grow="true"
                                LabelAlign="Right">
                            </ext:ComboBox>
                            <ext:ComboBox ID="cboJobClassification"
                                Name="cboJobClassification"
                                runat="server"
                                FieldLabel="Job Classification Category" LabelWidth="180"
                                Editable="false"
                                GrowToLongestValue="true"
                                Grow="true"
                                LabelAlign="Right">
                            </ext:ComboBox>
                        </Items>
                    </ext:Panel>
                    <ext:Panel ID="pnlAccount" 
                        runat="server" 
                        Title="Patient Portal Account" 
                        BodyPadding="6" 
                        AnchorHorizontal="100%" 
                        AnchorVertical="100%" 
                        Layout="AnchorLayout" 
                        OverflowY="Auto" 
                        OverflowX="Auto" 
                        Frame="false" 
                        Border="false" 
                        Visible="false">
                        <Content>
                            <uc:PatPortalAccount ID="ucPatPortalAccount" runat="server" ClientIDMode="Static" />
                        </Content>
                        </ext:Panel>
                </Items>
            </ext:TabPanel>
</asp:Content>

<asp:Content ID="cScripts" ContentPlaceHolderID="cpScripts" runat="server">
    <script type="text/javascript">
        function specifyLanguage(ele) {
            if (ele.getValue() == 7 /*Other, specify*/) {
                Ext.getCmp('txtPreferredLanguage').setValue('');
                Ext.getCmp('txtPreferredLanguage').show();
            }
            else {
                Ext.getCmp('txtPreferredLanguage').hide();
                Ext.getCmp('txtPreferredLanguage').setValue(ele.getRawValue());
            }
        }
    </script>
</asp:Content>
